/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Create Line Convenience Functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

HRESULT GetCreateLineLineInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineLineInput")

	HRESULT status = CONV_SUCCESS;

	double startX1 = -0.1;
	double startY1 = 0.1;
	double endX1 = 0.1;
	double endY1 = 0.1;

	double startX2 = -0.1;
	double startY2 = -0.1;
	double endX2 = 0.1;
	double endY2 = -0.1;

	ILine *pLine1 = NULL;
	status = CreateLine(startX1, startY1, endX1, endY1, &pLine1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine2 = NULL;
	status = CreateLine(startX2, startY2, endX2, endY2, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineLineInput")
}

HRESULT GetCreateCircleLineInput(ILine **circle1, ILine **line1)
{

	START_METHOD("GetCreateCircleLineInput")

	HRESULT status = CONV_SUCCESS;

	double centerX = -0.06;
	double centerY = 0.06;
	double radius = 0.03;

	double startX = -0.1;
	double startY = -0.1;
	double endX = 0.1;
	double endY = -0.1;

	ILine *pCircle1 = NULL;
	status = CreateCircle(centerX, centerY, radius, &pCircle1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &pLine1);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*line1 = pLine1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateCircleLineInput")
}

HRESULT GetCreateLineCircleInput(ILine **line1, ILine **circle1)
{

	START_METHOD("GetCreateLineCircleInput")

	HRESULT status = CONV_SUCCESS;

	double startX = -0.1;
	double startY = 0.1;
	double endX = 0.1;
	double endY = 0.1;

	double centerX = -0.06;
	double centerY = -0.06;
	double radius = 0.03;

	ILine *pLine1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &pLine1);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle1 = NULL;
	status = CreateCircle(centerX, centerY, radius, &pCircle1);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*circle1 = pCircle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineCircleInput")
}

HRESULT GetCreateCircleCircleInput(ILine **circle1, ILine **circle2)
{

	START_METHOD("GetCreateCircleCircleInput")

	HRESULT status = CONV_SUCCESS;

	double centerX1 = 0.07;
	double centerY1 = 0.07;
	double radius1 = 0.03;

	double centerX2 = -0.05;
	double centerY2 = -0.05;
	double radius2 = 0.05;

	ILine *pCircle1 = NULL;
	status = CreateCircle(centerX1, centerY1, radius1, &pCircle1);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle2 = NULL;
	status = CreateCircle(centerX2, centerY2, radius2, &pCircle2);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*circle2 = pCircle2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateCircleCircleInput")
}

HRESULT GetCreateLineStartToStartInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineStartToStartInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineStartToStartInput")
}

HRESULT GetCreateLineStartToMiddleInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineStartToMiddleInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineStartToMiddleInput")
}

HRESULT GetCreateLineStartToEndInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineStartToEndInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineStartToEndInput")
}

HRESULT GetCreateLineMiddleToStartInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineMiddleToStartInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineMiddleToStartInput")
}

HRESULT GetCreateLineMiddleToMiddleInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineMiddleToMiddleInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineMiddleToMiddleInput")
}

HRESULT GetCreateLineMiddleToEndInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineMiddleToEndInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineMiddleToEndInput")
}

HRESULT GetCreateLineEndToStartInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineEndToStartInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineEndToStartInput")
}

HRESULT GetCreateLineEndToMiddleInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineEndToMiddleInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineEndToMiddleInput")
}

HRESULT GetCreateLineEndToEndInput(ILine **line1, ILine **line2)
{

	START_METHOD("GetCreateLineEndToEndInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pLine2 = NULL;

	status = GetCreateLineLineInput(&pLine1, &pLine2);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*line2 = pLine2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineEndToEndInput")
}

HRESULT GetCreateLineCenterToStartInput(ILine **circle1, ILine **line1)
{

	START_METHOD("GetCreateLineCenterToStartInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pCircle1 = NULL;
	ILine *pLine1 = NULL;

	status = GetCreateCircleLineInput(&pCircle1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*line1 = pLine1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineCenterToStartInput")
}

HRESULT GetCreateLineCenterToMiddleInput(ILine **circle1, ILine **line1)
{

	START_METHOD("GetCreateLineCenterToMiddleInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pCircle1 = NULL;
	ILine *pLine1 = NULL;

	status = GetCreateCircleLineInput(&pCircle1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*line1 = pLine1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineCenterToMiddleInput")
}

HRESULT GetCreateLineCenterToEndInput(ILine **circle1, ILine **line1)
{

	START_METHOD("GetCreateLineCenterToEndInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pCircle1 = NULL;
	ILine *pLine1 = NULL;

	status = GetCreateCircleLineInput(&pCircle1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*line1 = pLine1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineCenterToEndInput")
}

HRESULT GetCreateLineStartToCenterInput(ILine **line1, ILine **circle1)
{

	START_METHOD("GetCreateLineStartToCenterInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pCircle1 = NULL;

	status = GetCreateLineCircleInput(&pLine1, &pCircle1);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*circle1 = pCircle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineStartToCenterInput")
}

HRESULT GetCreateLineMiddleToCenterInput(ILine **line1, ILine **circle1)
{

	START_METHOD("GetCreateLineMiddleToCenterInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pCircle1 = NULL;

	status = GetCreateLineCircleInput(&pLine1, &pCircle1);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*circle1 = pCircle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineMiddleToCenterInput")
}

HRESULT GetCreateLineEndToCenterInput(ILine **line1, ILine **circle1)
{

	START_METHOD("GetCreateLineEndToCenterInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pLine1 = NULL;
	ILine *pCircle1 = NULL;

	status = GetCreateLineCircleInput(&pLine1, &pCircle1);
	CHECK_RETURN_STATUS(status)

	*line1 = pLine1;
	*circle1 = pCircle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineEndToCenterInput")
}

HRESULT GetCreateLineCenterToCenterInput(ILine **circle1, ILine **circle2)
{

	START_METHOD("GetCreateLineCenterToCenterInput")

	HRESULT status = CONV_SUCCESS;

	ILine *pCircle1 = NULL;
	ILine *pCircle2 = NULL;

	status = GetCreateCircleCircleInput(&pCircle1, &pCircle2);
	CHECK_RETURN_STATUS(status)

	*circle1 = pCircle1;
	*circle2 = pCircle2;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCreateLineCenterToCenterInput")
}
